/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4-BIT FULL ADDERS WITH FAST CARRY
TRUTHTABLE     : 

      ---------------------------------------------------------
         INPUT :         C0/ C2=L                C0 /C2=H
       A1 B1  A2 B2   SIGMA1 SIGMA2  C2     SIGMA1 SIGMA2  C2
       A3 B3  A4 B4   SIGMA3 SIGMA4  C4     SIGMA3 SIGMA4  C4
      ---------------------------------------------------------
       L  L   L  L       L      L      L       H      L      L
       H  L   L  L       H      L      L       L      H      L
       L  H   L  L       H      L      L       L      H      L
       H  H   L  L       L      H      L       H      H      L
       L  L   H  L       L      H      L       H      H      L
       H  L   H  L       H      H      L       L      L      H
       L  H   H  L       H      H      L       L      L      H
       H  H   H  L       L      L      H       H      L      H
       L  L   L  H       L      H      L       H      H      L
       H  L   L  H       H      H      L       L      L      H
       L  H   L  H       H      H      L       L      L      H
       H  H   L  H       L      L      H       H      L      H
       L  L   H  H       L      L      H       H      L      H
       H  L   H  H       H      L      H       L      H      H
       L  H   H  H       H      L      H       L      H      H
       H  H   H  H       L      H      H       H      H      H  
      --------------------------------------------------------- 

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY  : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a83 (a4, sum3, a3, b3, sum2, b2, a2, sum1, a1, b1, c0, c4, sum4, b4);
	parameter size =1;
	input
		a4,
		a3,
		b3,
		b2,
		a2,
		a1,
		b1,
		c0,
		b4;
	output
		sum3,
		sum2,
		sum1,
		c4,
		sum4;
    nand
	M83_inst_ND1 (m83_inst_wnd1, b4, a4);
    nand
	M83_inst_ND2 (m83_inst_wnd2, b3, a3);
    nand
	M83_inst_ND3 (m83_inst_wnd3, b2, a2);
    nand
	M83_inst_ND4 (m83_inst_wnd4, b1, a1);
    not
	M83_inst_I1 (m83_inst_wi1, c0);
    not
	M83_inst_I2 (m83_inst_wi2, m83_inst_wi1);
    not
	M83_inst_I3 (m83_inst_wi3, m83_inst_wn5);
    not
	M83_inst_I4 (m83_inst_wi4, m83_inst_wn6);
    not
	M83_inst_I5 (m83_inst_wi5, m83_inst_wn7);
    not
	M83_inst_I6 (m83_inst_wi6, m83_inst_wn8);
    xor  
	M83_inst_X1 (sum4, m83_inst_wan5, m83_inst_wn2);
    xor  
	M83_inst_X2 (sum3, m83_inst_wan9, m83_inst_wn3);
    xor  
	M83_inst_X3 (sum2, m83_inst_wan12, m83_inst_wn4);
    xor  
	M83_inst_X4 (sum1, m83_inst_wan14, m83_inst_wi2);
    and
	M83_inst_AN1 (m83_inst_wan1, m83_inst_wn6, m83_inst_wnd1);
    and
	M83_inst_AN2 (m83_inst_wan2, m83_inst_wn7, m83_inst_wnd1, m83_inst_wnd2);
    and
	M83_inst_AN3 (m83_inst_wan3, m83_inst_wn8, m83_inst_wnd1, m83_inst_wnd2, m83_inst_wnd3);
    and
	M83_inst_AN4 (m83_inst_wan4, m83_inst_wnd1, m83_inst_wnd2, m83_inst_wnd3, m83_inst_wnd4, m83_inst_wi1);
    and
	M83_inst_AN5 (m83_inst_wan5, m83_inst_wnd1, m83_inst_wi3);
    and
	M83_inst_AN6 (m83_inst_wan6, m83_inst_wn7, m83_inst_wnd2);
    and
	M83_inst_AN7 (m83_inst_wan7, m83_inst_wn8, m83_inst_wnd2, m83_inst_wnd3);
    and
	M83_inst_AN8 (m83_inst_wan8, m83_inst_wnd2, m83_inst_wnd3, m83_inst_wnd4, m83_inst_wi1);
    and
	M83_inst_AN9 (m83_inst_wan9, m83_inst_wnd2, m83_inst_wi4);
    and
	M83_inst_AN10 (m83_inst_wan10, m83_inst_wn8, m83_inst_wnd3);
    and
	M83_inst_AN11 (m83_inst_wan11, m83_inst_wnd3, m83_inst_wnd4, m83_inst_wi1);
    and
	M83_inst_AN12 (m83_inst_wan12, m83_inst_wnd3, m83_inst_wi5);
    and
	M83_inst_AN13 (m83_inst_wan13, m83_inst_wnd4, m83_inst_wi1);
    and
	M83_inst_AN14 (m83_inst_wan14, m83_inst_wnd4, m83_inst_wi6);
    nor  
	M83_inst_N1 (c4, m83_inst_wbuf1, m83_inst_wan1, m83_inst_wan2, m83_inst_wan3, m83_inst_wan4);
    nor
	M83_inst_N2 (m83_inst_wn2, m83_inst_wbuf2, m83_inst_wan6, m83_inst_wan7, m83_inst_wan8);
    nor
	M83_inst_N3 (m83_inst_wn3, m83_inst_wbuf3, m83_inst_wan10, m83_inst_wan11);
    nor
	M83_inst_N4 (m83_inst_wn4, m83_inst_wbuf4, m83_inst_wan13);
    nor
	M83_inst_N5 (m83_inst_wn5, b4, a4);
    nor
	M83_inst_N6 (m83_inst_wn6, b3, a3);
    nor
	M83_inst_N7 (m83_inst_wn7, b2, a2);
    nor
	M83_inst_N8 (m83_inst_wn8, b1, a1);
    buf
	M83_inst_BUF1 (m83_inst_wbuf1, m83_inst_wn5);
    buf
	M83_inst_BUF2 (m83_inst_wbuf2, m83_inst_wn6);
    buf
	M83_inst_BUF3 (m83_inst_wbuf3, m83_inst_wn7);
    buf
	M83_inst_BUF4 (m83_inst_wbuf4, m83_inst_wn8);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
